#pragma once
#include "RegStorage.h"
#include "FileUtil.h"
/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
//** DB File **//
#define		kOptionSection					"Option"
//** Profile Option **//
#define		kFalse							0
#define		kPrevious						0
#define		kStartNew						1
#define		kAutoSave						2
#define		kDiscard						3
#define		kPrompt							4

#define		kProfileOnStartupKey			"ProfileOnStartup"
#define		kProfileOnStartupDefault		kPrevious

#define		kResetConfigFileOnStartupKey	"ResetConfigFileOnStartup"
#define		kResetConfigFileOnStartupDefaut	kFalse

#define		kProfileOnCloseKey				"ProfileOnClose"
#define		kProfileOnCloseDefault			kAutoSave
//** Phone Option **//
#define		kDefault						5
#define		kCustom							6
#define		kReady							7
#define		kPIN1Expected					8
#define		kPIN2Expected					9
#define		kPUK1Expected					10
#define		kPUK2Expected					11
#define		kPhoneState						15

#define		kPhoneStatusOnStartupKey		"PhoneStatusOnStartup"
#define		kPhoneStatusOnStartupDefault	kDefault

#define		kPhonePowerKey					"PhonePower"
#define		kPhonePowerDefault				1

#define		kPhoneFuncKey					"PhoneFunc"
#define		kPhoneFuncDefault				0

#define		kPhoneSecuKey					"PhoneSecu"
#define		kPhoneSecuDefault				kPhoneState

#define		kNwkRegKey						"NwkReg"
#define		kNwkRegDefault					0
//** Dialog Option **//
#define		kRemember						12
#define		kOpenAll						13
#define		kNone							14
//** Read Only **//
#define		kReadOnlyKey					"ReadOnly"
#define		kReadOnlyDefault				0

#define		kDialogStartupKey				"DialogStartup"
#define		kDialogStartupDefault			kRemember
//** Reply AT cmd **//
#define		kReplyUnknownPythonKey			"ReplyUnknownPython"
#define		kReplyUnknownPythonDefault		0
///////////////////////////////////////////////////////////////////////
class COMMON_API COption
{
private:
	CRegStorage* mStorage;	
	
	//** Profile Option **//
	// what is done with phone and comm dll on startup
	int		mProfileOnStartup;
	// what is done with phone config state
	int		mResetConfigFileOnStartup;
	// what is done when vp close, save, prompt or discard changes
	int		mProfileOnClose;
	//** Phone Option **//
	// state of power/fun/pin/reg on startup
	int		mPhoneStatusOnStartup;
	int		mPhonePower;
	int		mPhoneFunc;
	int		mPhoneSecu;
	int		mNwkReg;
	//** Dialog Option **//
	// what is done with configs dialogs on startup, always open, never open, remember
	int		mDialogStartup;		
	//		used to know if some option has changed, needed on create a new profile to ask to save before close
	BOOL	mHasChanged;
	//	Read only profile : Desactivate the profile setup option
	BOOL	mReadOnly;
	//** Reply AT cmd **//
	BOOL	mReplyUnknownPython;
public:
	COption(CRegStorage* iStorage);
	virtual ~COption(void);
	//** SetFileStorage **//
	CFileDB*	GetFileStorage() {return CFileUtil::GetFileUtil()->GetMainConfigFile();};
	//** Profile Option **//
	int		GetProfileOnStartup()						{return mProfileOnStartup;};
	void	SetProfileOnStartup(int iProfilePref)		{mProfileOnStartup=iProfilePref;mHasChanged=TRUE;};
	int	ResetConfigFile()								{return mResetConfigFileOnStartup;};
	void	SetResetConfigFile(int iReset)				{mResetConfigFileOnStartup=iReset;mHasChanged=TRUE;};
	int		GetProfileOnClose()							{return mProfileOnClose;};
	void	SetProfileOnClose(int iProfilePref)			{mProfileOnClose=iProfilePref;mHasChanged=TRUE;};
	//** Phone Option **//
	int		GetPhoneStatusOnStartup()					{return mPhoneStatusOnStartup;};
	void	SetPhoneStatusOnStartup(int iPhoneStatus)	{mPhoneStatusOnStartup=iPhoneStatus;mHasChanged=TRUE;};
	int		GetPhonePower()								{return mPhonePower;};
	void	SetPhonePower(int iPower)					{mPhonePower=iPower;mHasChanged=TRUE;};
	int		GetPhoneFunc()								{return mPhoneFunc;};
	void	SetPhoneFunc(int iFunc)						{mPhoneFunc=iFunc;mHasChanged=TRUE;};
	int		GetPhoneSecu()								{return mPhoneSecu;};
	void	SetPhoneSecu(int iSecu)						{mPhoneSecu=iSecu;mHasChanged=TRUE;};
	int		GetNwkReg()									{return mNwkReg;};
	void	SetNwkReg(int iNwkReg)						{mNwkReg=iNwkReg;mHasChanged=TRUE;};
	//** Dialog Option **//
	int		GetDialogStartup()							{return mDialogStartup;};
	void	SetDialogStartup(int iDialogPref)			{mDialogStartup=iDialogPref;mHasChanged=TRUE;};
	// Load/Save
	void	LoadFromRegistery();
	void	LoadFromFile();
	void	Save();
	void	DeleteFileSection();
	//
	BOOL HasChanged() {return mHasChanged;};	
	// Read Only
	void	SetReadOnly(BOOL iRO) {mReadOnly=iRO;};
	BOOL	IsReadOnly() {return mReadOnly;};
	// Python
	void	SetReplyUnknownPython(BOOL iRP) {mReplyUnknownPython=iRP;};
	BOOL	IsReplyUnknownPython() {return mReplyUnknownPython;};
};
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////